package gov.va.med.mhv.sm.api.transfer;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.time.DateFormatUtils;

@XmlRootElement(name = "Search")
public class MessageSearchFormTO implements Serializable {
	private static final long serialVersionUID = 6856086636023806096L;
	
	public static String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
	
	private boolean exactMatch;
	private String senderName;
	private String subject;
	private String recipientName;
	private Date fromDate;
	private Date toDate;

	public MessageSearchFormTO() {
	}

	public MessageSearchFormTO(boolean exactMatch, String sender, String subject,
			String recipient, Date fromDate, Date toDate) {
		this.exactMatch = exactMatch;
		this.senderName = sender;
		this.subject = subject;
		this.recipientName = recipient;
		this.fromDate = fromDate;
		this.toDate = toDate;
	}

	public boolean isExactMatch() {
		return exactMatch;
	}
	public void setExactMatch(boolean exactMatch) {
		this.exactMatch = exactMatch;
	}
	public String getSender() {
		return senderName;
	}
	public void setSender(String sender) {
		this.senderName = sender;
	}
	public String getSubject() {
		return subject;
	}
	public void setSubject(String subject) {
		this.subject = subject;
	}
	public String getRecipient() {
		return recipientName;
	}
	public void setRecipient(String recipient) {
		this.recipientName = recipient;
	}
	public String getFromDate() {
		return (fromDate!=null?DateFormatUtils.formatUTC(fromDate, RFC1123_PATTERN):"");
//		return (fromDate!=null?DateUtils.formatDate(fromDate):"");
	}
	public Date getFromDateAsDate() {
		return fromDate;
	}
	public void setFromDate(Date fromDate) {
		this.fromDate = fromDate;
	}
	public String getToDate() {
		return (toDate!=null?DateFormatUtils.formatUTC(toDate, RFC1123_PATTERN):"");
//		return (toDate!=null?DateUtils.formatDate(toDate):"");
	}
	public Date getToDateAsDate() {
		return toDate;
	}
	public void setToDate(Date toDate) {
		this.toDate = toDate;
	}

}
